require( "scripts/style.lua" );


local yes="yes" ;
local no="no" ;	

DoNotShowFont = {
  standardFont,
  12,
  BorderColor
};

if (gDialogTable.yeslabel) then
	yes = gDialogTable.yeslabel ;
end
if (gDialogTable.nolabel) then
	no = gDialogTable.nolabel ;
end

local donotshow = gDialogTable.donotshow;

function MakeDoNotShow()
	if (donotshow ~= nil and donotshow ~= '') then
		return Group {
			Button
			{
				graphics = CheckboxButtonGraphics,
				name="yesno_remember",
				type = kToggle,
				x=150,
				y=220,
				w=250,
				tx = 25,
				ty = 10,
				xoffset = 0,
				yoffset = 0,
				scale = 0.5,
				label = donotshow,
				font = RememberFont,
				flags = kHAlignLeft + kVAlignTop,
				command =
					function()
						
					end
				
			};
		};
	else
		return Group {
		
		};
	end
end

bitmapType = Bitmap;
if (gDialogTable.popthrough and gDialogTable.popthrough == true) then
	bitmapType = PopThroughBitmap;
end
MakeDialog
{
    bitmapType
    {
        name="yesnobackground",
		image="backgrounds/popup",
		x=kCenter,
		y=kCenter,
        
        SetStyle(StandardButtonStyle);
        Button
        {
			command=
				function()
					if (gDialogTable.yes) then 
						gDialogTable.yes() ; 
					end
					if (GetChecked('yesno_remember')) then
						SetStrSetting(donotshow, 'true');
					end
				end;
            close = true,
            flags = 5,
            label = yes,
            name = "yes",
            x = 65,
            y = 155,
        },
        Button
        {
			command=
				function() 
					if (gDialogTable.no) then
						gDialogTable.no() ; 
					end
					if (GetChecked('yesno_remember')) then
						SetStrSetting(donotshow, 'true');
					end
                end;
            close = true,
            flags = 5,
            label = no,
            name = "no",
            x = 235,
            y = 155,
        },
        SetStyle(DefaultStyle);
        
        Text
		{
			font = DialogTitleFont,
			name = "yesnotitle",
			x=12, y=8,
			w=kMax,h=40,
			flags = kVAlignCenter + kHAlignLeft,
			label= gDialogTable.title,
		};
		
		Text
		{
			font = {
				standardFont,
				26,
				BlackColor
			},
			name = "yesnobody",
			x=30,y=kPopupDialogTopY,
			w=kMax-40,h=135-kPopupDialogTopY,
			flags = kVAlignCenter + kHAlignCenter,
			label= gDialogTable.body,
		};
		
		Text
		{
			font = DialogBodyFont,
			name = "yesnotip",
			x=50,y=185,
			w=kMax-70,h=kMax-20,
			flags = kVAlignCenter + kHAlignCenter,
			label= gDialogTable.tip,
		};
		
		MakeDoNotShow();
    },

} -- MakeDialog

gDialogTable.tip = "";


